% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmissing.R
\name{rmissing}
\alias{rmissing}
\title{Identifies missing points between sample and collected data}
\usage{
rmissing(sampdf, colldf, col_name)
}
\arguments{
\item{sampdf}{object containing data frame of sample points}

\item{colldf}{object containing data frame of collected data}

\item{col_name}{common variable (i.e. key) in data frames by which to check for missing points}
}
\value{
Returns table of sample points missing from collected data
}
\description{
Identifies missing points between sample and collected data
}
\examples{
alsample <- rsamp(df=albania, 544)
alreceived <- rsamp(df=alsample, 390)
rmissing(sampdf=alsample, colldf=alreceived, col_name=qvKod)
}
\references{
Simplified wrapper around dplyr::anti_join()
}
