% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplingin.R
\name{doSampling}
\alias{doSampling}
\title{Select Samples Given its Parameters}
\usage{
doSampling(
  pop,
  alloc,
  nsampel,
  type,
  strata = NULL,
  ident = c("kdprov", "kdkab"),
  implicitby = NULL,
  method = "systematic",
  auxVar = NA,
  seed = 1,
  predetermined_rn = NULL,
  verbose = TRUE
)
}
\arguments{
\item{pop}{pop dataframe}

\item{alloc}{allocation dataframe}

\item{nsampel}{variable on alloc df as allocation sample}

\item{type}{type value for sample classification ('U' = Primary Samples, 'P' = Secondary Samples)}

\item{strata}{strata variable, must available on both pop and alloc dataframe}

\item{ident}{group by on allocation dataframe}

\item{implicitby}{variable used as implicit stratification}

\item{method}{method of sampling : \code{"systematic"} (the default) or \code{"pps"}}

\item{auxVar}{auxiliary variable for pps sampling (\code{method = "pps"})}

\item{seed}{seed}

\item{predetermined_rn}{predetermined random number variable on allocation dataframe, the default value is NULL, random number will be generated randomly}

\item{verbose}{verbose (\code{TRUE} as default)}
}
\value{
list of population data (\code{"pop"}), selected samples (\code{"dsampel"}), and details of sampling process (\code{"rincian"})
}
\description{
Samples selection using systematic or PPS (Probability Proportional to Size) sampling method.
}
\examples{

\donttest{
library(samplingin)
library(magrittr)
library(dplyr)

# PPS Sampling
dtSampling_pps = doSampling(
   pop = pop_dt
   , alloc = alokasi_dt
   , nsampel = "n_primary"
   , type = "U"
   , ident = c("kdprov")
   , method = "pps"
   , auxVar = "Total"
   , seed = 1234
)

# Population data with flag sample
pop_dt = dtSampling_pps$pop

# Selected Samples
dsampel = dtSampling_pps$dsampel

# Details of sampling process
rincian = dtSampling_pps$rincian

# Systematic Sampling
dtSampling_sys = doSampling(
   pop = pop_dt
   , alloc = alokasi_dt
   , nsampel = "n_primary"
   , type = "U"
   , ident = c("kdprov")
   , method = "systematic"
   , seed = 4321
)

# Population data with flag sample
pop_dt = dtSampling_sys$pop

# Selected Samples
dsampel = dtSampling_sys$dsampel

# Details of sampling process
rincian = dtSampling_sys$rincian

#' Systematic Sampling with predetermined random number (predetermined_ar parameter)

alokasi_dt_rn = alokasi_dt \%>\% rowwise() \%>\% mutate(ar = runif(n(),0,1))

dtSampling_sys = doSampling(
   pop = pop_dt
   , alloc = alokasi_dt_rn
   , nsampel = "n_primary"
   , type = "U"
   , ident = c("kdprov")
   , method = "systematic"
   , predetermined_rn = "ar"
   , seed = 4321
)

# Population data with flag sample
pop_dt = dtSampling_sys$pop

# Selected Samples
dsampel = dtSampling_sys$dsampel

# Details of sampling process
rincian = dtSampling_sys$rincian
}
}
