% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_fit.R
\name{santaR_fit}
\alias{santaR_fit}
\title{Generate a SANTAObj for a variable}
\usage{
santaR_fit(inputMatrix, df, grouping = NA, verbose = TRUE)
}
\arguments{
\item{inputMatrix}{\code{data.frame} of measurements for each IND x TIME as generated by \code{\link{get_ind_time_matrix}}. Rows are unique Individual IDs and columns unique measurement Time. Pairs of (IND,TIME) without a measurement are left as NA.}

\item{df}{(float) Degree of freedom to employ for fitting the \code{\link[stats]{smooth.spline}}}

\item{grouping}{NA or a \code{data.frame} with 2 columns (ind and group) listing as rows each unique Individual ID and the corresponding group membership, as generated by \code{\link{get_grouping}}. Default is NA for no groups.}

\item{verbose}{(bool) If TRUE output the progress of fitting. Default is TRUE.}
}
\value{
A \emph{SANTAObj} containing all the spline models with individual and group time evolutions, for further analysis.

\subsection{Details:}{
  The returned \emph{SANTAObj} is structured as follow:
  \tabular{ll}{
    SANTAObj \tab santaR object for futher analysis\cr
     \tab \cr
    SANTAObj$properties$df \tab input degree of freedom\cr
    SANTAObj$properties$CBand$status \tab Confidence Bands for group mean curve calculated \emph{(TRUE or FALSE)}\cr
    SANTAObj$properties$CBand$nBoot \tab parameter, number or bootstrap rounds for calculation of the group mean curve confidence bands\cr
    SANTAObj$properties$CBand$alpha \tab parameter, confidence of the group mean curve band\cr
    SANTAObj$properties$pval.dist$status \tab \emph{p}-value distance calculated \emph{(TRUE or FALSE)}\cr
    SANTAObj$properties$pval.dist$nPerm \tab parameter, number of permutations for calculation of distance \emph{p}-value\cr
    SANTAObj$properties$pval.dist$alpha \tab parameter, confidence on the bootstrapped \emph{p}-value\cr
    SANTAObj$properties$pval.fit$status \tab \emph{p}-value fitting calculated \emph{(TRUE or FALSE)}\cr
    SANTAObj$properties$pval.fit$nPerm \tab parameter, number of permutations for calculation of fitting \emph{p}-value\cr
    SANTAObj$properties$pval.fit$alpha \tab parameter, confidence on the bootstrapped \emph{p}-value\cr
     \tab \cr
    SANTAObj$general$inputData \tab \emph{inputMatrix}\cr
    SANTAObj$general$cleanData.in \tab only kept individuals INPUT values \emph{(equivalent to inputMatrix - rejected)}\cr
    SANTAObj$general$cleanData.pred \tab only kept individuals PREDICTED values on Ind splines\cr
    SANTAObj$general$grouping \tab grouping vector given as input\cr
    SANTAObj$general$meanCurve \tab spline fit over all kept datapoint \emph{(cleanData.pred)} | \code{\link[stats]{smooth.spline}} object\cr
    SANTAObj$general$pval.curveCorr \tab Pearson correlation coefficient between the two group curves, to detect highly correlated group shapes if required.\cr
    SANTAObj$general$pval.dist \tab \emph{p}-value between groups based on distance between groupMeanCurves\cr
    SANTAObj$general$pval.dist.l \tab lower bound confidence interval on \emph{p}-value\cr
    SANTAObj$general$pval.dist.u \tab upper bound confidence interval on \emph{p}-value\cr
    SANTAObj$general$pval.fit \tab \emph{p}-value between groups based on groupMeanCurves fitting\cr
    SANTAObj$general$pval.fit.l \tab lower bound confidence interval on \emph{p}-value\cr
    SANTAObj$general$pval.fit.u \tab upper bound confidence interval on \emph{p}-value\cr
     \tab \cr
    SANTAObj$groups \tab list of group information\cr
    SANTAObj$groups$rejectedInd \tab list of rejected individual \emph{(#tp < 4 or df)} | data\cr
    SANTAObj$groups$curveInd \tab list of spline fit | \code{\link[stats]{smooth.spline}} object\cr
    SANTAObj$groups$groupMeanCurve \tab spline fit over groupData.pred | \code{\link[stats]{smooth.spline}} object\cr
    SANTAObj$groups$point.in \tab all group points INPUT values (x,y) [kept individuals]\cr
    SANTAObj$groups$point.pred \tab all group points PREDICTED values on Ind splines (x,y)\cr
    SANTAObj$groups$groupData.in \tab only individuals from this group INPUT value (IND x TIME)\cr
    SANTAObj$groups$groupData.pred \tab only individuals from this group PREDICTED values on Ind splines (x,y)
  }
}
}
\description{
Generate a \emph{SANTAObj} containing all the splines model for individual and group time evolutions. Once all the splines representing individual and group evolutions are fitted, all time-points are back-projected (projected) and employed in subsequent analysis in place of the input measurements (functional approach). A grouping can be provided to separate individuals and compare trajectories: any number of groups can be provided, but comparision of group trajectories can only be executed between 2 groups.
\itemize{
  \item Individual trajectories with less than 4 time-points are rejected due to constraints on \code{\link[stats]{smooth.spline}} fitting \emph{(number of time-points < 4)}.
  \item Individual trajectories with less time-points than \emph{df} are rejected due to constraints on \code{\link[stats]{smooth.spline}} fitting \emph{(number of time-points < df)}.
  \item Rejected individual trajectories are not taken into account for mean curves calculations.
}
}
\examples{
## 56 measurements, 8 subjects, 7 unique time-points
Yi             <- acuteInflammation$data$var_1
ind            <- acuteInflammation$meta$ind
time           <- acuteInflammation$meta$time
group          <- acuteInflammation$meta$group
grouping       <- get_grouping(ind, group)
inputMatrix    <- get_ind_time_matrix(Yi, ind, time)
resultSANTAObj <- santaR_fit(inputMatrix, df=5, grouping=grouping, verbose=TRUE)

}
\seealso{
Other Analysis: \code{\link{get_grouping}},
  \code{\link{get_ind_time_matrix}},
  \code{\link{santaR_CBand}},
  \code{\link{santaR_auto_fit}},
  \code{\link{santaR_auto_summary}},
  \code{\link{santaR_plot}},
  \code{\link{santaR_pvalue_dist}},
  \code{\link{santaR_pvalue_fit}},
  \code{\link{santaR_start_GUI}}
}
