% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_search.R
\name{get_eigen_DFoverlay_list}
\alias{get_eigen_DFoverlay_list}
\title{Plot for each eigenSpline the automatically fitted spline, splines for all df and a spline at a chosen df}
\usage{
get_eigen_DFoverlay_list(
  eigen,
  manualDf = 5,
  nPC = NA,
  step = NA,
  showPt = TRUE,
  autofit = TRUE
)
}
\arguments{
\item{eigen}{A list of eigenSpline parameters as generated by \code{\link{get_eigen_spline}}, containing \code{eigen$matrix}, \code{eigen$variance}, \code{eigen$model} and \code{eigen$countTP}.}

\item{manualDf}{(int) A manually selected \emph{df}. Default is 5.}

\item{nPC}{(int) The first \emph{n} eigenSplines to plot. Default is NA, plot all eigenSplines.}

\item{step}{(float) The \emph{df} increment employed to plot splines over the range of \emph{df}.}

\item{showPt}{(bool) If True the eigenSpline data points are plotted. Default is TRUE.}

\item{autofit}{(bool) If True the automatically fitted splines \emph{(using CV)} are plotted. Default is TRUE.}
}
\value{
A list of \code{ggplot2} plotObjects, one plot per eigenSpline. All results can be plotted using \code{do.call(grid.arrange, returnedResult)}.
}
\description{
Plot for each eigenSpline the automatically fitted spline (red), splines for all possible \emph{df} (grey) and a spline at a manually chosen \emph{df} (blue).
}
\examples{
## 8 subjects, 4 time-points, 3 variables
inputData  <- acuteInflammation$data[0:32,1:3]
ind        <- acuteInflammation$meta$ind[0:32]
time       <- acuteInflammation$meta$time[0:32]
eigen      <- get_eigen_spline(inputData, ind, time, nPC=NA, scaling="scaling_UV",
                               method="nipals", verbose=TRUE, centering=TRUE, ncores=0)
paramSpace <- get_param_evolution(eigen, step=1)
plotList   <- get_eigen_DFoverlay_list(eigen,manualDf=3,step=0.5,showPt=TRUE,autofit=TRUE)
plotList[1]
# do.call(grid.arrange, plotList)

}
\seealso{
Graphical implementation with \code{\link{santaR_start_GUI}}

Other DFsearch: 
\code{\link{get_eigen_DF}()},
\code{\link{get_eigen_spline}()},
\code{\link{get_param_evolution}()},
\code{\link{plot_nbTP_histogram}()},
\code{\link{plot_param_evolution}()}
}
\concept{DFsearch}
