% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{lbl_discrete}
\alias{lbl_discrete}
\title{Label discrete data}
\usage{
lbl_discrete(symbol = " - ", fmt = NULL)
}
\arguments{
\item{symbol}{String: symbol to use for the dash.}

\item{fmt}{A format. Can be a string, passed into \code{\link[base:sprintf]{base::sprintf()}} or \code{\link[=format]{format()}}
methods; or a one-argument formatting function.}
}
\value{
A vector of labels for \code{chop}, or a function that creates labels.
}
\description{
\lifecycle{experimental}
}
\details{
\code{lbl_discrete} creates labels for discrete data such as integers.
For example, breaks
\code{c(1, 3, 4, 6, 7)} are labelled: \verb{"1 - 2", "3", "4 - 5", "6 - 7"}.

No check is done that the data is discrete-valued. If it isn't, then
these labels may be misleading. Here, discrete-valued means that if
\code{x < y}, then \code{x <= y - 1}.

Be aware that Date objects may have non-integer values. See \link{Date}.
}
\examples{
tab(1:7, c(1, 3, 5), lbl_discrete())

# Misleading labels for non-integer data
chop(2.5, c(1, 3, 5), lbl_discrete())
}
\seealso{
Other labelling functions: 
\code{\link{lbl_dash}()},
\code{\link{lbl_format}()},
\code{\link{lbl_intervals}()},
\code{\link{lbl_manual}()},
\code{\link{lbl_seq}()}
}
\concept{labelling functions}
