% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{lbl_endpoint}
\alias{lbl_endpoint}
\title{Label chopped intervals by their left or right endpoints}
\usage{
lbl_endpoint(fmt = NULL, raw = FALSE, left = TRUE)
}
\arguments{
\item{fmt}{A format. Can be a string, passed into \code{\link[base:sprintf]{base::sprintf()}} or \code{\link[=format]{format()}}
methods; or a one-argument formatting function.}

\item{raw}{Logical. Always use raw \code{breaks} in labels, rather than e.g. quantiles
or standard deviations?}

\item{left}{Flag. Use left endpoint or right endpoint?}
}
\value{
A vector of labels for \code{chop}, or a function that creates labels.
}
\description{
This is useful when the left endpoint unambiguously indicates the
interval.
}
\examples{
chop(1:10, c(2, 5, 8), lbl_endpoint(left = TRUE))
chop(1:10, c(2, 5, 8), lbl_endpoint(left = FALSE))
if (requireNamespace("lubridate")) {
  tab_width(
          as.Date("2000-01-01") + 0:365,
         months(1),
         labels = lbl_endpoint(fmt = "\%b")
       )
}
}
