% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotKM}
\alias{plotKM}
\title{Plot Kaplan-Meier curves for a gene set}
\usage{
plotKM(geneset, survivalTimes, followup, title = NA, y.label = NA,
  x.label = NA, p.text = NA, ...)
}
\arguments{
\item{geneset}{A geneset as returned by \code{\link{saps}}.}

\item{survivalTimes}{A vector of survival times, as used in a call to
\code{\link{saps}}.}

\item{followup}{A vector of 0 or 1 values, indicating whether the patient was
lost to followup (0) or not (1), as used in a call to \code{\link{saps}}.}

\item{title}{The plot title. Defaults to "Kaplan-Meier curves for geneset
[\code{geneset["name"]}]".}

\item{y.label}{The y-axis label. Defaults to "Probability of survival".}

\item{x.label}{The x-axis label. Defaults to "Overall survival".}

\item{p.text}{Text to display in the lower left hand corner. Defaults to
displaying \code{p_pure} and \code{p_pure_adj}.}

\item{...}{Additional arguments to be passed to \code{\link[survcomp]{km.coxph.plot}}}
}
\description{
Plots Kaplan-Meier survival curves for a given gene set using the
    cluster labels generated during the computation of \code{p_pure} to
    stratify patients into two survival groups. The function is a wrapper for
    \code{\link[survcomp]{km.coxph.plot}} in the \pkg{survcomp} package.
}
\examples{
# 25 patients, none lost to followup
followup <- rep(1, 25)

# first 5 patients have good survival (in days)
time <- c(25, 27, 24, 21, 26, sample(1:3, 20, TRUE))*365

# create data for 100 genes, 25 patients
dat <- matrix(rnorm(25*100), nrow=25, ncol=100)
colnames(dat) <- as.character(1:100)

# create two random genesets of 5 genes each
set1 <- sample(colnames(dat), 5)
set2 <- sample(colnames(dat), 5)

genesets <- rbind(set1, set2)

# run saps
\dontrun{
results <- saps(genesets, dat, time, followup, random.samples=100)

set <- results$genesets[["set1"]]

# KM plots should not seperate at this point
plotKM(set, time/365, followup, x.label="Overall survival (years)")

# increase expression levels for set1 for first 5 patients
dat[1:5, set1] <- dat[1:5, set1]+10

# run saps again
results <- saps(genesets, dat, time, followup, random.samples=100)

set <- results$genesets[["set1"]]

# KM plots should now seperate
plotKM(set, time/365, followup, x.label="Overall survival (years)")
}
}
\seealso{
\code{\link{saps}} \code{\link{calculatePPure}}
    \code{\link[survcomp]{km.coxph.plot}}
}

