% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotRandomDensity}
\alias{plotRandomDensity}
\title{Draw density plot of \code{p_pure} values for random gene sets}
\usage{
plotRandomDensity(geneset, ...)
}
\arguments{
\item{geneset}{A geneset as returned by \code{\link{saps}}.}

\item{...}{Additional arguments to be passed to \code{\link{plot}}}
}
\description{
This function retrieves the \code{p_pure} values for the
    random gene sets generated during the computation of \code{p_random} for
    a given gene set. These are drawn as a density plot, with the value of
    \code{p_pure} for the gene set indicated. The value of \code{p_random}
    for the gene set is displayed as well.
}
\examples{
# 25 patients, none lost to followup
followup <- rep(1, 25)

# first 5 patients have good survival (in days)
time <- c(25, 27, 24, 21, 26, sample(1:3, 20, TRUE))*365

# create data for 100 genes, 25 patients
dat <- matrix(rnorm(25*100), nrow=25, ncol=100)
colnames(dat) <- as.character(1:100)

# create two random genesets of 5 genes each
set1 <- sample(colnames(dat), 5)
set2 <- sample(colnames(dat), 5)

genesets <- rbind(set1, set2)

# run saps
\dontrun{
results <- saps(genesets, dat, time, followup, random.samples=100)

set <- results$genesets[["set1"]]

# should not be significant
plotRandomDensity(set)

# increase expression levels for set1 for first 5 patients
dat[1:5, set1] <- dat[1:5, set1]+10

# run saps again
results <- saps(genesets, dat, time, followup, random.samples=100)

set <- results$genesets[["set1"]]

# now it should be significant
plotRandomDensity(set)
}
}
\seealso{
\code{\link{saps}} \code{\link{calculatePRandom}}
}

