% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.snowprofileCsv.R
\name{export.snowprofileCsv}
\alias{export.snowprofileCsv}
\title{Export or write a snowprofile object to a CSV table}
\usage{
export.snowprofileCsv(
  profile,
  filename = stop("filename must be provided"),
  sep = ",",
  export.all = "Layers",
  variables = NA
)
}
\arguments{
\item{profile}{\link{snowprofile} object}

\item{filename}{character string, e.g. 'path/to/file.csv'}

\item{sep}{csv column separator as character string}

\item{export.all}{one of \code{TRUE}, \code{FALSE}, \code{'Layers'}: export all variables of the snowprofile object to the csv table?

If \code{'Layers'}, then all layer variables of the snowprofile will be exported.}

\item{variables}{A tag-value list of the format, e.g. height = 'height_top', to specify column names of specific variables,
to customize column order, and/or to include specific profile meta data if \code{export.all == 'Layers'}
(e.g. easily include the meta data \code{station_id}). Note that the
tags of the tag-value list need to correspond to elements of the snowprofile object.}
}
\value{
Writes csv file to disk, no return value in R
}
\description{
Export or write a snowprofile object to a CSV table
}
\details{
Note that existing files with the specified filename will be \strong{overwritten} without warning!
}
\examples{

## export an entire snowprofile object:

export.snowprofileCsv(SPpairs$A_manual, filename = file.path(tempdir(), 'file.csv'),
                      export.all = TRUE)


## export only the layer properties of a snowprofile object,
#  and change the column order with few column names:
#  All layer variables will be exported, but the three ones provided in 'variables'
#  will be the first three columns of the csv table, and their column names will be changed
#  accordingly.

export.snowprofileCsv(SPpairs$A_manual, filename = file.path(tempdir(), 'file.csv'),
                      export.all = 'Layers',
                      variables = list(height = 'height_top', hardness = 'hardness',
                                       gtype = 'gt1'))


## export all layer properties of a snowprofile object plus the station ID:

export.snowprofileCsv(SPpairs$A_manual, filename = file.path(tempdir(), 'file.csv'),
                      export.all = 'Layers', variables = list(station_id = 'station_id'))

## check the content of the exported csv file:
csv_content <- read.csv(file.path(tempdir(), 'file.csv'))
head(csv_content)

## or re-import the csv file as snowprofile object:
csv_snowprofile <- snowprofileCsv(file.path(tempdir(), 'file.csv'))
print(csv_snowprofile)

}
\seealso{
\link{snowprofileCsv}
}
\author{
fherla
}
