% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_pomdpx.R
\name{write_pomdpx}
\alias{write_pomdpx}
\title{write pomdpx files}
\usage{
write_pomdpx(
  P,
  O,
  R,
  gamma,
  b = rep(1/dim(O)[1], dim(O)[1]),
  file = "input.pomdpx",
  digits = 12,
  digits2 = 12,
  format = "f"
)
}
\arguments{
\item{P}{transition matrix}

\item{O}{observation matrix}

\item{R}{reward}

\item{gamma}{discount factor}

\item{b}{initial belief}

\item{file}{pomdpx file to create}

\item{digits}{precision to round to before normalizing.
Leave at 4 since sarsop seems unable to do more?}

\item{digits2}{precision to write solution to. Leave at 10,
since normalizing requires additional precision}

\item{format}{floating point format, because sarsop parser
doesn't seem to know scientific notation}
}
\description{
A POMDPX file specifies a POMDP problem in terms of the transition,
observation, and reward matrices, the discount factor, and the initial
belief.
}
\examples{
m <- fisheries_matrices()
f <- tempfile()
write_pomdpx(m$transition, m$observation, m$reward, 0.95,
             file = f)

}
