% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satres.R
\name{get_band_names}
\alias{get_band_names}
\alias{get_band_names.satres}
\title{Get band names}
\usage{
get_band_names(sr, res)

\method{get_band_names}{satres}(sr, res = NULL)
}
\arguments{
\item{sr}{A \code{satres} object.}

\item{res}{A string, spatial resolution.}
}
\value{
A vector of strings.
}
\description{
Returns all names of the multi-band raster that make up the object.
}
\details{
We can indicate the name of a certain spatial resolution to obtain only
its names.
}
\examples{

esa <- system.file("extdata", "esa", package = "satres")
sr <- satres(dir = esa, only_spectral_bands = FALSE)
r <- sr |>
     get_band_names()

}
\seealso{
\code{\link{sat_untarzip}}

Other satellite definition: 
\code{\link{get_spatial_resolution}()},
\code{\link{get_spectral_band_names}()},
\code{\link{satres}()}
}
\concept{satellite definition}
