% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbfc.R
\name{signal_var_proportion}
\alias{signal_var_proportion}
\title{Signal variable proportion}
\usage{
signal_var_proportion(sbfc_result, nvars = 10, samples = F,
  labels = paste0("X", 1:ncol(sbfc_result$parents)), label_size = 1,
  rotate_labels = F)
}
\arguments{
\item{sbfc_result}{An object of class \code{sbfc}.}

\item{nvars}{Number of top signal variables to include in the plot (default=10).}

\item{samples}{Calculate signal variable proportion based on sampled MCMC graphs after burn-in and thinning,
rather than graphs from all iterations (default=FALSE).}

\item{labels}{A vector of node labels (default=\code{c("X1","X2",...)}).}

\item{label_size}{Size of variable labels on the X-axis (default=1).}

\item{rotate_labels}{Rotate x-axis labels by 90 degrees to make them vertical (default=FALSE)}
}
\value{
Signal proportion for the top \code{nvars} variables in decreasing order.
}
\description{
For each variable, computes the proportion of the samples in which this variable is in the signal group (Group 1). 
Plots the top \code{nvars} variables in decreasing order of signal proportion.
}

