% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-SimpleSBM_fit.R
\name{SimpleSBM_fit}
\alias{SimpleSBM_fit}
\title{R6 Class definition of a Simple SBM fit}
\description{
R6 Class definition of a Simple SBM fit

R6 Class definition of a Simple SBM fit
}
\details{
This class is designed to give a representation and adjust an SBM fitted with blockmodels.
}
\section{Super classes}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{\link[sbm:SBM_fit]{sbm::SBM_fit}} -> \code{SimpleSBM_fit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nbNodes}}{number of nodes}

\item{\code{nbBlocks}}{number of blocks}

\item{\code{nbDyads}}{number of dyads (potential edges in the network)}

\item{\code{memberships}}{vector of clustering}

\item{\code{nbConnectParam}}{number of parameter used for the connectivity}

\item{\code{directed}}{is the network directed or not}

\item{\code{penalty}}{double, value of the penalty term in ICL}

\item{\code{entropy}}{double, value of the entropy due to the clustering distribution}

\item{\code{storedModels}}{data.frame of all models fitted (and stored) during the optimization}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SimpleSBM_fit$new()}}
\item \href{#method-optimize}{\code{SimpleSBM_fit$optimize()}}
\item \href{#method-predict}{\code{SimpleSBM_fit$predict()}}
\item \href{#method-reorder}{\code{SimpleSBM_fit$reorder()}}
\item \href{#method-show}{\code{SimpleSBM_fit$show()}}
\item \href{#method-clone}{\code{SimpleSBM_fit$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="plot">}\href{../../sbm/html/SBM.html#method-plot}{\code{sbm::SBM$plot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="print">}\href{../../sbm/html/SBM.html#method-print}{\code{sbm::SBM$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM_fit" data-id="setModel">}\href{../../sbm/html/SBM_fit.html#method-setModel}{\code{sbm::SBM_fit$setModel()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for a Simple SBM fit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$new(
  adjacencyMatrix,
  model,
  directed,
  dimLabels = list(row = "rowLabel", col = "colLabel"),
  covarList = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{adjacencyMatrix}}{square (weighted) matrix}

\item{\code{model}}{character (\code{'bernoulli'}, \code{'poisson'}, \code{'gaussian'})}

\item{\code{directed}}{logical, directed network or not. In not, \code{adjacencyMatrix} must be symmetric.}

\item{\code{dimLabels}}{list of labels of each dimension (in row, in columns)}

\item{\code{covarList}}{and optional list of covariates, each of whom must have the same dimension as \code{adjacencyMatrix}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
function to perform optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$optimize(
  verbosity = 3,
  plot = FALSE,
  explorFactor = 1.5,
  nbBlocksRange = c(4, Inf),
  nbCores = 2,
  fast = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbosity}}{integer, the level of verbosity. Default to 3}

\item{\code{plot}}{logical, if TRUE ploting is done dynamically on the screen. Default to \code{TRUE}}

\item{\code{explorFactor}}{double factor for exploring successive model}

\item{\code{nbBlocksRange}}{2-size vector: range of exploration}

\item{\code{nbCores}}{integer, the number of cores to use. Default is 2.}

\item{\code{fast}}{logical: should approximation be used for Bernoulli model with covariates. Default to \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
prediction under the currently estimated model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$predict(covarList = self$covarList)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{covarList}}{a list of covariates. By default, we use the covariates with which the model was estimated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a matrix of expected values for each dyad
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reorder"></a>}}
\if{latex}{\out{\hypertarget{method-reorder}{}}}
\subsection{Method \code{reorder()}}{
permute group labels by order of decreasing probability
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$reorder()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$show(type = "Fit of a Simple Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character used to specify the type of SBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_fit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
