% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_sim.r
\name{plot_comb_sims}
\alias{plot_comb_sims}
\title{Plot the simulation time courses using a heatmap representation.}
\usage{
plot_comb_sims(inputdir, outputdir, model, exp_dataset,
  plot_exp_dataset = FALSE, exp_dataset_alpha = 1, xaxis_label = "",
  yaxis_label = "", column_to_read = "X1", yaxis.min = NULL,
  yaxis.max = NULL)
}
\arguments{
\item{inputdir}{the input directory containing the time course files}

\item{outputdir}{the output directory}

\item{model}{the model name}

\item{exp_dataset}{a full path file containing the experimental data.}

\item{plot_exp_dataset}{TRUE if the experimental data should also be plotted}

\item{exp_dataset_alpha}{the alpha level for the data set}

\item{xaxis_label}{the label for the x axis (e.g. Time (min))}

\item{yaxis_label}{the label for the y axis (e.g. Level (a.u.))}

\item{column_to_read}{the name of the column to process}

\item{yaxis.min}{the lower limit for the y axis}

\item{yaxis.max}{the upper limit for the y axis}
}
\description{
Plot the simulation time courses using a heatmap representation.
}
\examples{
data(insulin_receptor_IR_beta_pY1146)
data(insulin_receptor_exp_dataset)
dir.create(file.path("sim_datasets_sum"))
write.table(insulin_receptor_IR_beta_pY1146, 
            file=file.path("sim_datasets_sum","insulin_receptor_IR_beta_pY1146.csv"), 
            row.names=FALSE)
write.table(insulin_receptor_exp_dataset, 
            file="insulin_receptor_exp_dataset.csv", 
            row.names=FALSE)
plot_comb_sims(inputdir="sim_datasets_sum", 
               outputdir="sim_plots",
               model="insulin_receptor",
               exp_dataset="insulin_receptor_exp_dataset.csv",
               plot_exp_dataset=TRUE, 
               exp_dataset_alpha=1.0, 
               xaxis_label="Time [m]", 
               yaxis_label="Level [a.u.]", 
               column_to_read='IR_beta_pY1146', 
               yaxis.min=NULL, 
               yaxis.max=NULL)
}
