% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_plots.r
\name{plot_raw_dataset}
\alias{plot_raw_dataset}
\title{Add experimental data points to a plot. The length of the experimental time course to 
plot is limited by the length of the simulated time course (=max_sim_tp).}
\usage{
plot_raw_dataset(df_exp_dataset, g = ggplot(), readout = "time",
  max_sim_tp = 0, alpha = 1, yaxis.min = NULL, yaxis.max = NULL)
}
\arguments{
\item{df_exp_dataset}{the experimental data set}

\item{g}{the current ggplot to overlap}

\item{readout}{the name of the readout}

\item{max_sim_tp}{the maximum simulated time point}

\item{alpha}{the amount of alpha transparency}

\item{yaxis.min}{the lower limit for the y axis}

\item{yaxis.max}{the upper limit for the y axis}
}
\value{
the plot
}
\description{
Add experimental data points to a plot. The length of the experimental time course to 
plot is limited by the length of the simulated time course (=max_sim_tp).
}
\examples{
data(insulin_receptor_exp_dataset)
plot_raw_dataset(insulin_receptor_exp_dataset, readout="IR_beta_pY1146", 
                 max_sim_tp=30, alpha=1, yaxis.min=NULL, yaxis.max=NULL) 
}
