% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifier_exists.R
\name{identifier_exists}
\alias{identifier_exists}
\title{Check if identifier exists}
\usage{
identifier_exists(sb_id, ..., session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
Logical, \code{TRUE} or \code{FALSE}
}
\description{
This function quickly checks to see if an identifier exists. 
It does a quick head request to skip the overhead of item metadta retrieval.
This will also return \code{FALSE} if the identifier exists but is associated
with an item that is unavailable due to permission restrictions.
}
\examples{
\donttest{
# identifier exists
identifier_exists(sb_id = "4f4e4b24e4b07f02db6aea14")

# identifier does not exist
identifier_exists(sb_id = "aaaaaaakkkkkkkbbbbbb")
}
}
