% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Iterative_Plotting.R
\name{Iterate_DimPlot_bySample}
\alias{Iterate_DimPlot_bySample}
\title{Iterate DimPlot By Sample}
\usage{
Iterate_DimPlot_bySample(
  seurat_object,
  file_path = NULL,
  file_name = NULL,
  file_type = NULL,
  single_pdf = FALSE,
  dpi = 600,
  color = "black",
  legend = TRUE,
  reduction = NULL,
  dims = c(1, 2),
  pt.size = NULL,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{file_path}{directory file path and/or file name prefix.  Defaults to current wd.}

\item{file_name}{name suffix to append after sample name.}

\item{file_type}{File type to save output as.  Must be one of following: ".pdf", ".png", ".tiff", ".jpeg", or ".svg".}

\item{single_pdf}{saves all plots to single PDF file (default = FALSE).  `file_type`` must be .pdf}

\item{dpi}{dpi for image saving.}

\item{color}{color scheme to use.}

\item{legend}{logical, whether or not to include plot legend, default is TRUE.}

\item{reduction}{Dimensionality Reduction to use (default is object default).}

\item{dims}{Dimensions to plot.}

\item{pt.size}{Adjust point size for plotting.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{DimPlot}}.}
}
\value{
A ggplot object
}
\description{
Iterate DimPlot by orig.ident column from Seurat object metadata
}
\examples{
\dontrun{
Iterate_DimPlot_bySample(seurat_object = object, file_path = "plots/", file_name = "tsne",
file_type = ".jpg", dpi = 600, color = "black")
}

}
\concept{iterative_plotting}
