% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{CellBender_Feature_Diff}
\alias{CellBender_Feature_Diff}
\title{CellBender Feature Differences}
\usage{
CellBender_Feature_Diff(seurat_object, raw_assay, cell_bender_assay)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{raw_assay}{Name of the assay containing the raw count data.}

\item{cell_bender_assay}{Name of the assay containing the CellBender count data.}
}
\value{
A data.frame containing summed raw counts, CellBender counts, count difference, and
percent difference in counts.
}
\description{
Get quick values for raw counts, CellBender counts, count differences, and percent count differences
per feature.
}
\examples{
\dontrun{
cb_stats <- CellBender_Feature_Diff(seurat_object - obj, raw_assay = "RAW",
cell_bender_assay = "RNA")
}

}
\concept{stats}
