% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_Plotting_Seq_10X.R
\name{Barcode_Plot}
\alias{Barcode_Plot}
\title{Create Barcode Rank Plot}
\usage{
Barcode_Plot(
  br_out,
  pt.size = 6,
  plot_title = "Barcode Ranks",
  raster_dpi = c(1024, 1024),
  plateau = NULL
)
}
\arguments{
\item{br_out}{DFrame output from \code{\link[DropletUtils]{barcodeRanks}}.}

\item{pt.size}{point size for plotting, default is 6.}

\item{plot_title}{Title for plot, default is "Barcode Ranks".}

\item{raster_dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(1024, 1024).}

\item{plateau}{numerical value at which to add vertical line designating estimated
empty droplet plateau (default is NULL).}
}
\value{
A ggplot object
}
\description{
Plot UMI vs. Barcode Rank with inflection and knee.  Requires input from DropletUtils package.
}
\examples{
\dontrun{
mat <- Read10X_h5(filename = "raw_feature_bc_matrix.h5")

br_results <- DropletUtils::barcodeRanks(mat)

Barcode_Plot(br_out = br_results)
}

}
\concept{seq_qc_plotting_basic}
