% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_&_Write_Data.R
\name{Read_Metrics_10X}
\alias{Read_Metrics_10X}
\title{Read Overall Statistics from 10X Cell Ranger Count}
\usage{
Read_Metrics_10X(
  base_path,
  secondary_path = NULL,
  default_10X = TRUE,
  cellranger_multi = FALSE,
  lib_list = NULL,
  lib_names = NULL
)
}
\arguments{
\item{base_path}{path to the parent directory which contains all of the subdirectories of interest or
alternatively can provide single csv file to read and format identically to reading multiple files.}

\item{secondary_path}{path from the parent directory to count "outs/" folder which contains the
"metrics_summary.csv" file.}

\item{default_10X}{logical (default TRUE) sets the secondary path variable to the default 10X directory structure.}

\item{cellranger_multi}{logical, whether or not metrics come from Cell Ranger \code{count} or from Cell Ranger \code{multi}.  Default is FALSE.}

\item{lib_list}{a list of sample names (matching directory names) to import.  If \code{NULL} will read
in all samples in parent directory.}

\item{lib_names}{a set of sample names to use for each sample.  If \code{NULL} will set names to the
directory name of each sample.}
}
\value{
A data frame or list of data.frames with sample metrics from cell ranger.
}
\description{
Get data.frame with all metrics from the Cell Ranger count analysis (present in web_summary.html)
}
\examples{
\dontrun{
metrics <- Read_Metrics_10X(base_path = "/path/to/directories", default_10X = TRUE)
}

}
\concept{read_&_write}
