% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Split_Vector}
\alias{Split_Vector}
\title{Split vector into list}
\usage{
Split_Vector(x, chunk_size = NULL, num_chunk = NULL, verbose = FALSE)
}
\arguments{
\item{x}{vector to split}

\item{chunk_size}{size of chunks for vector to be split into, default is NULL.  Only valid if
\code{num_chunk} is NULL.}

\item{num_chunk}{number of chunks to split the vector into, default is NULL.  Only valid if
\code{chunk_size} is NULL.}

\item{verbose}{logical, print details of vector and split, default is FALSE.}
}
\value{
list with vector of X length
}
\description{
Splits vector into chunks of x sizes
}
\examples{
vector <- c("gene1", "gene2", "gene3", "gene4", "gene5", "gene6")

vector_list <- Split_Vector(x = vector, chunk_size = 3)

}
\references{
Base code from stackoverflow post:
\url{https://stackoverflow.com/a/3321659/15568251}
}
\concept{misc_util}
