% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCR.ClonalStateDistribution.R
\name{BCR.ClonalStateDistribution}
\alias{BCR.ClonalStateDistribution}
\title{Distribution of clonal status of single-cell BCR clonotypes}
\usage{
BCR.ClonalStateDistribution(contigList, sampleName)
}
\arguments{
\item{contigList}{The product of TCR.ContigList() or BCR.ContigList().}

\item{sampleName}{The sample name of single cell sample.}
}
\value{
Multiple pictures in the form of a list.
}
\description{
Distribution of clonal status of single-cell BCR clonotypes
}
\examples{

project_data_dir <- "F:/R_Language/data/bcr"
sample_name <- list.dirs(project_data_dir, full.names = FALSE, recursive = FALSE)
group_name <- c("A", "A", "B", "B")

contig_list <- BCR.ContigList(project_data_dir, sample_name, group_name)

TCR.ClonalStateDistribution(contig_list, sample_name)

BasicPlot(TCR.ClonalStateDistribution, contig_list, sample_name)
}
