% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sclink_net}
\alias{sclink_net}
\title{Infer gene co-expression networks}
\usage{
sclink_net(expr, ncores, lda = seq(1, 0.1, -0.05), nthre = 20, dthre = 0.9)
}
\arguments{
\item{expr}{A gene expression matrix with rows representing cells and columns representing genes.
Gene names are given as column names. Can be the output of \code{sclink_norm} or user constructed gene
expression matrices.}

\item{ncores}{Number of cores if using parallel computation.}

\item{lda}{A vector specifying a sequence of lambda values to be used in the penalized likelihood.}

\item{nthre}{An integer specifying a threshold on the number of complete observations.
Defaults to 20.}

\item{dthre}{A number specifying the threshold on dropout probabilities. Defaults to 0.9.}
}
\value{
A list for gene co-expression relationships. The list contains a \code{cor} element for
scLink's correlation matrix and a \code{summary} element for the gene networks. \code{summary} is a list
with each element corresponding to the result of one lambda value. Each element of \code{summary}
contains the following information:
\describe{
  \item{adj:}{the adjacency matrix specifying the gene-gene edges;}
  \item{Sigma:}{the estimated concentration matrix;}
  \item{nedge:}{number of edges in the gene network;}
  \item{bic:}{BIC score;}
  \item{lambda:}{value of lambda in the penalty.}
}
}
\description{
Infer gene co-expression networks
}
\examples{
\donttest{
count = readRDS(system.file("extdata", "example.rds", package = "scLink"))
count.norm = sclink_norm(count, scale.factor = 1e6, filter.genes = TRUE, n = 500)
networks = sclink_net(expr = count.norm, ncores = 1, lda = seq(0.5, 0.1, -0.05))
}
}
\author{
Wei Vivian Li, \email{vivian.li@rutgers.edu}
}
