% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_reviewNeurons.R
\name{updateNeurons}
\alias{updateNeurons}
\title{Update the classifications of neurons from SCALPEL.}
\usage{
updateNeurons(scalpelOutput, neuronSet)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{neuronSet}{The set of neurons that should be reviewed:
use \code{"A"} for those resulting from \code{\link{scalpelStep2}} and saved as \code{scalpelOutput$A}, or use \code{"Afilter"} for those resulting from
\code{\link{scalpelStep3}} and saved as \code{scalpelOutput$Afilter}. This argument is ignored if the class of \code{scalpelOutput} is \code{scalpelStep2}.}
}
\value{
None
}
\description{
This function allows the user to update the classifications of neurons, based on manual sorting of
plots saved as a result of running \code{\link{reviewNeurons}}.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "reviewNeurons" function

updateNeurons(scalpelOutput = scalpelOutput, neuronSet = "Afilter")
}
}
\seealso{
\code{\link{reviewNeurons}}, \code{\link{reviewNeuronsMoreFrames}}, \code{\link{reviewOverlappingNeurons}}
}

