% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleSC.R
\name{scaleSC}
\alias{scaleSC}
\title{Scaling values of an scdf file}
\usage{
scaleSC(data, var, center = TRUE, scale = FALSE, m = 0, sd = 1,
  grand = TRUE)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{var}{A character string or a vector of character strings with variable
names that should be scaled.}

\item{center}{If set TRUE, data are mean centered.}

\item{scale}{If set TRUE, the standard deviation is set.}

\item{m}{The target mean for centering.}

\item{sd}{The target standard deviation for scaling}

\item{grand}{If set TRUE, scaling is based on the mean and standarddeviation
of all measurements across all single-cases within the scdf.}
}
\value{
An scdf with the scaled values.
}
\description{
This function scales the measured values of an scdf file. It allows for mean
centering and standardization based on each s?ingle-case data set or a
scaling across all cases included in an scdf.
}
\examples{

## Standardize a multiple case scdf and compute an hplm
ex_sc <- scaleSC(exampleAB_50, var = "values", center = TRUE, scale = TRUE)
hplm(ex_sc)

}
\seealso{
Other data manipulation functions: \code{\link{fillmissingSC}},
  \code{\link{longSCDF}}, \code{\link{outlierSC}},
  \code{\link{rankSC}}, \code{\link{shiftSC}},
  \code{\link{smoothSC}}, \code{\link{truncateSC}}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
