% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncateSC.R
\name{truncateSC}
\alias{truncateSC}
\title{Truncate single-case data}
\usage{
truncateSC(data, dvar, pvar, truncate = list(A = c(0, 0), B = c(0, 0)),
  na = TRUE)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to the attributes in the scdf file.}

\item{truncate}{A list with a vector of two (beginning and end) values for each phase defining the number of data points to be deleted.
For lists of single-case data frames, the truncation is adapted to the length 
of each phase for each single case.}

\item{na}{If FALSE, the truncated measurement times are deletet. If TRUE, NAs are set for the dependent variable.}
}
\value{
A truncated data frame (for each single-case).
}
\description{
This function truncates data points at the beginning and / or end each phase.
}
\examples{

# Truncate the first two data points of both phases and compare the two data sets
study <- c(
  "Original" = byHeart2011[1], 
  "Selected" = truncateSC(byHeart2011[1], truncate = list(A = c(2,0), B = c(2,0)))
)
plot(study)

}
\seealso{
Other data manipulation functions: \code{\link{fillmissingSC}},
  \code{\link{longSCDF}}, \code{\link{outlierSC}},
  \code{\link{rankSC}}, \code{\link{scaleSC}},
  \code{\link{shiftSC}}, \code{\link{smoothSC}}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{manip}
