% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fss_exponential_family.R
\name{poisson_priority}
\alias{poisson_priority}
\title{Compute Poisson priority function values cumulatively over time.}
\usage{
poisson_priority(counts, baselines, scalar_priority_fun = poisson_qmax)
}
\arguments{
\item{counts}{A matrix of observed counts. Rows represent timepoints, ordered
from most recent to most distant. Columns represent e.g. locations or
data streams.}

\item{baselines}{A matrix of expected counts with the same dimensions as
\code{counts}.}

\item{scalar_priority_fun}{A function taking two arguments \code{c} (count)
and \code{b} (baseline) and returning a scalar.}
}
\value{
A matrix with the same dimensions as \code{counts}. The \eqn{i}th 
   element in each column contains the Poisson priority function value for 
   the window of time (duration) stretching from 1 to \eqn{i}, for that
   column.
}
\description{
Given a matrices with observed and expected counts (baselines) for each 
timepoint (row) and location/data stream (column), sum counts and baselines 
cumulatively backwards in time, and compute the Poisson priority function
value for each column and subset of time.
}
\keyword{internal}
