% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCSCCellBrowser.R
\name{ParseCBDatasets}
\alias{ParseCBDatasets}
\title{Download UCSC Cell Browser Datasets.}
\usage{
ParseCBDatasets(
  sample.df = NULL,
  all.samples.df = NULL,
  collection = NULL,
  sub.collection = NULL,
  organ = NULL,
  disease = NULL,
  organism = NULL,
  project = NULL,
  fuzzy.match = TRUE,
  cell.num = NULL,
  timeout = 1000,
  merge = TRUE
)
}
\arguments{
\item{sample.df}{Dataframe contains used datasets. Default: NULL.}

\item{all.samples.df}{Dataframe contains all samples metadata, obtained with \code{ShowCBDatasets}. Default: NULL.
\code{sample.df} and \code{all.samples.df} cannot be both NULL.}

\item{collection}{The collection of the datasets, corresponds to \code{shortLabel} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{sub.collection}{The sub-collection of the datasets, corresponds to \code{subLabel} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{organ}{The organ of the datasets, corresponds to \code{body_parts} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{disease}{The disease of the datasets, corresponds to \code{diseases} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{organism}{The specie of the datasets, corresponds to \code{organisms} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{project}{The project of the datasets, corresponds to \code{projects} column
of \code{all.samples.df}, obtain available values with \code{StatDBAttribute}. Default: NULL (without filtering).}

\item{fuzzy.match}{Logical value, whether to perform fuzzy match with provided attribute values. Default: TRUE.}

\item{cell.num}{Cell number filter. If NULL, no filter; if one value, lower filter; if two values, low and high filter. Deault: NULL.}

\item{timeout}{Maximum request time when loading data online. Default: 1000.}

\item{merge}{Logical value, whether to merge Seurat list. Default: FALSE.}
}
\value{
Seurat object (if \code{merge} is TRUE) or list of Seurat objects (if \code{merge} is FALSE).
}
\description{
Download UCSC Cell Browser Datasets.
}
\examples{
\dontrun{
# lazy mode, load datasets json files locally, need users to provide json folder
ucsc.cb.samples <- ShowCBDatasets(lazy = TRUE, json.folder = NULL, update = FALSE)
# cell number is between 1000 and 2000
hbb.sample.df <- ExtractCBDatasets(
  all.samples.df = ucsc.cb.samples, organ = c("brain", "blood"),
  organism = "Human (H. sapiens)", cell.num = c(1000, 2000)
)
hbb.sample.seu <- ParseCBDatasets(sample.df = hbb.sample.df)
# test 10x and matrix load
complex.df <- ucsc.cb.samples[c(1, 927, 379), ] # two 10x and one matrix
complex.seu.list <- ParseCBDatasets(sample.df = test.df, merge = F)
}
}
