% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order.ijdata.R
\name{order.ijdata}
\alias{order.ijdata}
\title{Order IJDATA spot sequences and growth lines}
\usage{
order.ijdata(IJDATA, spots = "", gbs = "", print.order = FALSE)
}
\arguments{
\item{IJDATA}{an \code{\link[=read.ijdata]{IJDATA}} object.}

\item{spots}{a character or numeric vector specifying the desired order of sample spot sequences.}

\item{gbs}{a character or numeric vector specifying the desired order of growth lines.}

\item{print.order}{logical. Should the current order of spot sequences and growth lines be printed instead of changing the order?}
}
\description{
Reorders spot sequences and growth lines within object of class \code{\link[=read.ijdata]{IJDATA}}.
}
\details{
Reorders IJDATA \code{spot.x} and \code{spot.y} and/or \code{gbs.x} and \code{gbs.y} coordinate data.frames. Useful when order of ROIs does not correspond with the desired order of \code{\link{convert.ijdata}} or spot.dist output. Can also be used to print the order of spot sequences and growth lines within IJDATA object (see 'print.order'). In addition the function can also be used to drop spot sequences or growth lines from the data set by leaving out ROI names. In this case a warning is produced to confirm that the user has not forgotten something.
}
\examples{
data(shellspots)
order.ijdata(shellspots, print.order = TRUE) # Prints the current order. Does not change anything
dat <- order.ijdata(shellspots, gbs = c(1,3,6:14,4,5,2)) # Changes order of growth bands
order.ijdata(dat, print.order = TRUE)

## Subset the first sample spot sequence
dat2 <- order.ijdata(shellspots, gbs = 1:13)
## Warning message:
## In order.ijdata(shellspots, gbs = 1:13) :
## Length of gbs does not correspond the number of columns. Data removed.
order.ijdata(dat2, print.order = TRUE)
}
\author{
Mikko Vihtakari
}
\seealso{
\code{\link{read.ijdata}} for reading zip files containing ImageJ ROIs.

\code{\link{convert.ijdata}} for converting the coordinate information to \link[spatstat]{spatstat} point patterns.
}

