% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sclr_ideal_data.R
\name{sclr_ideal_data}
\alias{sclr_ideal_data}
\title{Generate ideal data for the scaled logit model}
\usage{
sclr_ideal_data(n = 1000, lambda = 0.5, beta_0 = -5,
  covariate_list = list(logHI = list(gen_fun = function(n) rnorm(n, 2,
  2), true_par = 2)), outcome_name = "status", seed = NULL,
  attach_true_vals = FALSE, attach_seed = FALSE)
}
\arguments{
\item{n}{Number of observations.}

\item{lambda}{Baseline risk parameter.}

\item{beta_0}{Intercept of the linear part.}

\item{covariate_list}{A list in the form of \code{name = list(gen_fun,
true_par)} where \code{gen_fun} is a function that takes \code{n} as an
argument and returns a vector of observations, \code{true_par} is the true
parameter value of that covariate. See examples.}

\item{outcome_name}{Name to give to the outcome}

\item{seed}{Seed to set. If \code{NULL}, no seed will be set.}

\item{attach_true_vals, attach_seed}{Whether to attach additional attributes.}
}
\value{
A \code{\link[tibble]{tibble}}.
}
\description{
Allows variation of all parameters and the creation of an arbitrary number of
covariates.
}
\examples{
# One titre
one_titre <- sclr_ideal_data(
  covariate_list = list(
    logHI = list(gen_fun = function(n) rnorm(n, 2, 2), true_par = 2)
  )
)
sclr(status ~ logHI, one_titre) # Verify

# Two titres
two_titre <- sclr_ideal_data(
  covariate_list = list(
    logHI = list(gen_fun = function(n) rnorm(n, 2, 2), true_par = 2),
    logNI = list(gen_fun = function(n) rnorm(n, 2, 2), true_par = 1)
  )
)
sclr(status ~ logHI + logNI, two_titre) # Verify

}
