% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tests.R
\name{nemenyiTest}
\alias{nemenyiTest}
\title{Nemenyi test}
\usage{
nemenyiTest(data, alpha = 0.05)
}
\arguments{
\item{data}{Matrix or data frame where each algorithm is in a column}

\item{alpha}{Significance level}
}
\value{
A list with class "htest" containing the following components: \code{statistic}, the value of the statistic used in the test; \code{method}, a character string indicating what type of test was performed; \code{data.name}, a character string giving the name of the data and \code{diff.matirx}, a matrix with all the pairwise differences of average rankings
}
\description{
This function performs the Nemenyi test
}
\details{
The test has been implemented according to the version in Demsar (2006), page 7
}
\examples{
data(data_gh_2008)
res <- nemenyiTest(data.gh.2008, alpha = 0.1)
res
res$diff.matrix
}
\references{
Demsar, J. (2006) Statistical Comparisons of Classifiers over Multiple Data Sets. \emph{Journal of Machine Learning Research}, 7, 1-30.
}

