% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{drawAlgorithmGraph}
\alias{drawAlgorithmGraph}
\title{Hypotheses represented as a graph}
\usage{
drawAlgorithmGraph(pvalue.matrix, mean.value, ..., alpha = 0.05,
  font.size = 15, highlight = "min", highlight.color = "chartreuse3",
  node.color = "gray30", font.color = "white", digits = 2,
  node.width = 5, node.height = 2)
}
\arguments{
\item{pvalue.matrix}{Matrix with the p-values}

\item{mean.value}{Vector of values to be written together with the name of the algorithm}

\item{...}{Additional parameters to the Rgraphviz function. This is mainly to change the layout of the graph}

\item{alpha}{Significance level to determine which hypotheses are rejected.}

\item{font.size}{Size of the font for the node labels.}

\item{highlight}{A character indicating which node has to be highlighted. It can be the one with the maximum value (\code{'max'}), the minimum value (\code{'min'}) or none (\code{'none'}).}

\item{highlight.color}{Any R valid color for the highlighted node.}

\item{node.color}{Any R valid color for the non-highlighted nodes.}

\item{font.color}{Any R valid color for the node labels.}

\item{digits}{Number of digits to display the value associated to each node}

\item{node.width}{Numeric value for the width of the node}

\item{node.height}{Numeric value for the height of the node}
}
\description{
This function can be used to plot a graph where algorithms are nodes and  algorithms that cannot be regarded as different are joined by an edge.
}
\examples{
data(data_blum_2015)
data <- filterData(data.blum.2015, condition="Size == 1000", remove.cols=1:2)
res <- postHocTest(data, test = "friedman", use.rank=TRUE, correct="bergmann")
drawAlgorithmGraph(res$corrected.pval, res$summary)
}
\seealso{
\code{\link{plotPvalues}}, \code{\link{plotRanking}}, \code{\link{plotCD}}
}

