% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scmamp.R
\name{multipleComparisonTest}
\alias{multipleComparisonTest}
\title{Tests for multiple comparisons}
\usage{
multipleComparisonTest(data, algorithms = NULL, group.by = NULL,
  test = "aligned ranks", correct = "finner", alpha = 0.05, ...)
}
\arguments{
\item{data}{A matrix or data frame containing the results obtained by the algorithms (columns) in each problem (rows). It can contain additional columns, but if any of the column has to be discarderd (not used neither to group the problems nor to be part of the comparison), then it is mandatory to indicate, in the \code{algorithms} parameter, which columns contain the algorithm information.}

\item{algorithms}{Vector with either the names or the indices of the columns that contain the values to be tested. If not provided, the function assumes that all the columns except those indicated in \code{group.by} represent the results obtained by an algorithm.}

\item{group.by}{Vector with either the names or the indices of the columns to be used to group the data. Each group is tested independently. If \code{NULL}, all the data is used for a single comparison.}

\item{test}{Parameter that indicates the statistical test to be used. It can be either a string indicating one of the available test or a function. As a string, it can take the following values:
\itemize{
  \item {\code{'friedman'} - Friedman test, as in Garcia and Herrera (2010)}
  \item {\code{'aligned ranks'} Friedman's Aligned Ranks test, as in Garcia and Herrera (2010)}
  \item {\code{'quade'} - Quade test, as in Garcia and Herrera (2010)} 
  \item {\code{'anova'} - ANOVA test, as in Test 22 in Kanji (2006).}
}

If a function is provided, then it has to have as first argument a matrix containing the columns to be compared. The function has to return a  list with, at least, an element named \code{p.value} (as the \code{htest} objects that are usually returned by R's test implementations).}

\item{correct}{Either string indicating the type of correction that has to be applied or a function to correct the p-values for multiple testing; This parameter is only need in case the data is grouped. As a string, the valid values are:
\itemize{
  \item{\code{holland} - Holland's procedure, as in Garcia and Herrera (2010)}
  \item{\code{finner} - Finner's procedure, as in Garcia and Herrera (2010)}
  \item{\code{rom} - Rom's procedure, as in Garcia and Herrera (2010)} 
  \item{\code{li} - Li's procedure, as in Garcia and Herrera (2010)}
  \item{Any of the methods implemented in the \code{p.adjust} function. For a list of options, type \code{p.adjust.methods}}
}. 
If a function is provided, the it has to recieve, as first argument, a vector of pvalues to be corrected and has to return a verctor with the corrected p-values \emph{in the same order} as the input vector.}

\item{alpha}{Alpha value used in Rom's correction. By default, set at 0.05.}

\item{...}{Special argument used to pass additional parameters to the statistical test and the correction method.}
}
\value{
In case the \code{group.by} argument is not provided (or it is \code{NULL}), the function return an object of class \code{htest}. If columns for grouping are provided, then the function returns a matrix that includes, for each group, the values of the \code{group.by} columns, the raw p-value and the corrected p-value.

#' @seealso \code{\link{friedmanTest}}, \code{\link{friedmanAlignedRanksTest}}, \code{\link{quadeTest}}, \code{\link{anovaTest}}, \code{\link{adjustShaffer}}, \code{\link{adjustBergmannHommel}}, \code{\link{adjustHolland}}, \code{\link{adjustFinner}}, \code{\link{adjustRom}}, \code{\link{adjustLi}}
}
\description{
This function is a wrapper to multiple comparison tests.
}
\examples{
# Grouped data
data(data_blum_2015)
multipleComparisonTest (data=data.blum.2015, 
                        algorithms=c("FrogCOL", "FrogMIS", "FruitFly"), 
                        group.by=c("Size", "Radius"), 
                        test="quade", correct="finner")
# Not grouped data
data(data_gh_2008)
multipleComparisonTest (data=data.gh.2008, test="aligned ranks", 
                        correct="hochberg")

}
\references{
S. Garcia and F. Herrera (2010) Advanced nonparametric tests for multiple comparisons in the design of experiments in computational intelligence and ata mining: Experimental analysis of power. \emph{Information Sciences}, 180, 2044-2064.

Kanji, G. K. (2006) \emph{100 Statistical Tests}. SAGE Publications Ltd, 3rd edition.
}

