% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotPvalues}
\alias{plotPvalues}
\title{Plotting the p-value matrix}
\usage{
plotPvalues(pvalue.matrix, alg.order = NULL, show.pvalue = TRUE,
  font.size = 5)
}
\arguments{
\item{pvalue.matrix}{Matrix with the p-values to plot}

\item{alg.order}{A permutation indicating the reordering of the algorithms}

\item{show.pvalue}{Logical value indicating whether the numerical values have to be printed}

\item{font.size}{Size of the p-values, if printed}
}
\value{
A \code{\link{ggplot}} object.
}
\description{
This function plots the p-value matrix as a tile plot.
}
\examples{
data(data_gh_2008)
pvalues <- friedmanPost(data.gh.2008)
ordering <- order(summarizeData(data.gh.2008))
plotPvalues(pvalues, alg.order=ordering)

}
\seealso{
\code{\link{drawAlgorithmGraph}}, \code{\link{plotCD}}
}

