% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_hot.R
\name{one_hot}
\alias{one_hot}
\title{One Hot Encoding}
\usage{
one_hot(dt, var_skip = NULL, var_encode = NULL, nacol_rm = FALSE,
  replace_na = -1, factor_to_integer = FALSE)
}
\arguments{
\item{dt}{A data frame.}

\item{var_skip}{Name of categorical variables that will skip and without doing one-hot encoding. Default is NULL.}

\item{var_encode}{Name of categorical variables to be one-hot encoded, default is NULL. If it is NULL, then all categorical variables except in var_skip are counted.}

\item{nacol_rm}{Logical. One-hot encoding on categorical variable contains missing values, whether to remove the column generated to indicate the presence of NAs. Default is FALSE.}

\item{replace_na}{Replace missing values with a specified value such as -1 by default, or the mean/median value of the variable in which they occur. If it is NULL, then no missing values will be replaced.}

\item{factor_to_integer}{Logical. Converting factor variables to integer. Default is FALSE.}
}
\value{
A dataframe
}
\description{
One-hot encoding on categorical variables. It is not needed when creating a standard scorecard model, but required in models that without doing woe transformation.
}
\examples{
# load germancredit data
data(germancredit)

library(data.table)
dat = rbind(
  germancredit,
  data.table(creditability=sample(c("good","bad"),10,replace=TRUE)),
  fill=TRUE)

# remove na columns
dat_onehot0 = one_hot(dat, var_skip = 'creditability', nacol_rm = FALSE) # default
dat_onehot1 = one_hot(dat, var_skip = 'creditability', nacol_rm = TRUE)

# replace missing values
dat_onehot2 = one_hot(dat, var_skip = 'creditability', replace_na = -1) # default
dat_onehot3 = one_hot(dat, var_skip = 'creditability', replace_na = 'median')
dat_onehot4 = one_hot(dat, var_skip = 'creditability', replace_na = NULL)

}
