% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dtree_split_val}
\alias{dtree_split_val}
\title{Getting the split value for terminal nodes from decision tree}
\usage{
dtree_split_val(desc_model, variable)
}
\arguments{
\item{desc_model}{ctree class model with one variable}

\item{variable}{numerical variable name which on which decision tree was run, to be passed as string}
}
\value{
The function returns a dataframe giving the lower and upper bound of split values of each node.
}
\description{
The function takes a ctree type model, with only one numerical variable, as argument input and gives a dataframe with the minimum and maximum value of each node. The intervals are open ended at lower limit and closed at upper limit.
}
\examples{
data <- iris
data$Y <- ifelse(data$Species=="setosa",1,0)
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
