% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise-comparisons.R
\name{add_rel_skill_to_eval_forecasts}
\alias{add_rel_skill_to_eval_forecasts}
\title{Add relative skill to eval_forecasts()}
\usage{
add_rel_skill_to_eval_forecasts(
  unsummarised_scores,
  rel_skill_metric,
  baseline,
  by,
  summarise_by,
  verbose
)
}
\arguments{
\item{unsummarised_scores}{unsummarised scores to be passed from
\code{\link{eval_forecasts}}}

\item{rel_skill_metric}{character string with the name of the metric for which
a relative skill shall be computed. If equal to 'auto' (the default), then
one of interval score, crps or brier score will be used where appropriate}

\item{baseline}{character string with the name of a model. If a baseline is
given, then a scaled relative skill with respect to the baseline will be
returned. By default (`NULL`), relative skill will not be scaled with
respect to a baseline model.}

\item{by}{character vector of columns to group scoring by. This should be the
lowest level of grouping possible, i.e. the unit of the individual
observation. This is important as many functions work on individual
observations. If you want a different level of aggregation, you should use
\code{summarise_by} to aggregate the individual scores.
Also not that the pit will be computed using \code{summarise_by}
instead of \code{by}}

\item{summarise_by}{character vector of columns to group the summary by. By
default, this is equal to `by` and no summary takes place.
But sometimes you may want to to summarise
over categories different from the scoring.
\code{summarise_by} is also the grouping level used to compute
(and possibly plot) the probability integral transform(pit).}

\item{verbose}{print out additional helpful messages (default is TRUE)}
}
\description{
This function will only be called within \code{\link{eval_forecasts}} and serves to
make pairwise comparisons from within that function. It uses the
`summarise_by` argument as well as the data from \code{\link{eval_forecasts}}.
Essentially, it wraps \code{\link{pairwise_comparison}} and deals with the specifics
necessary to work with \code{\link{eval_forecasts}}.
}
