% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avail_forecasts.R
\name{avail_forecasts}
\alias{avail_forecasts}
\title{Display Number of Forecasts Available}
\usage{
avail_forecasts(data, by = NULL, collapse = c("quantile", "sample"))
}
\arguments{
\item{data}{A data.frame or data.table with the predictions and observations.
For scoring using \code{\link[=score]{score()}}, the following columns need to be present:
\itemize{
\item \code{true_value} - the true observed values
\item \code{prediction} - predictions or predictive samples for one
true value. (You only don't need to provide a prediction column if
you want to score quantile forecasts in a wide range format.)}
For scoring integer and continuous forecasts a \code{sample} column is needed:
\itemize{
\item \code{sample} - an index to identify the predictive samples in the
prediction column generated by one model for one true value. Only
necessary for continuous and integer forecasts, not for
binary predictions.}
For scoring predictions in a quantile-format forecast you should provide
a column called \code{quantile}:
\itemize{
\item \code{quantile}: quantile to which the prediction corresponds
}

In addition a \code{model} column is suggested and if not present this will be
flagged and added to the input data with all forecasts assigned as an
"unspecified model").

You can check the format of your data using \code{\link[=check_forecasts]{check_forecasts()}} and there
are examples for each format (\link{example_quantile}, \link{example_continuous},
\link{example_integer}, and \link{example_binary}).}

\item{by}{character vector or \code{NULL} (the default) that denotes the
categories over which the number of forecasts should be counted.
By default (\code{by = NULL}) this will be the unit of a single forecast (i.e.
all available columns (apart from a few "protected" columns such as
'prediction' and 'true value') plus "quantile" or "sample" where present).}

\item{collapse}{character vector (default is \verb{c("quantile", "sample"}) with
names of categories for which the number of rows should be collapsed to one
when counting. For example, a single forecast is usually represented by a
set of several quantiles or samples and collapsing these to one makes sure
that a single forecast only gets counted once.}
}
\value{
A data.table with columns as specified in \code{by} and an additional
column with the number of forecasts.
}
\description{
Given a data set with forecasts, count the number of available forecasts
for arbitrary grouping (e.g. the number of forecasts per model, or the
number of forecasts per model and location).
This is useful to determine whether there are any missing forecasts.
}
\examples{
\dontshow{
  data.table::setDTthreads(2) # restricts number of cores used on CRAN
}

avail_forecasts(example_quantile,
  collapse = c("quantile"),
  by = c("model", "target_type")
)
}
\keyword{check-forecasts}
