% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapper-function-helpers.R
\name{manage_helper_col}
\alias{manage_helper_col}
\title{Helper column operations}
\usage{
manage_helper_col(data, var_arg, default, affix = TRUE)
}
\arguments{
\item{data}{The data frame that is the mapper function's first argument.}

\item{var_arg}{The argument to the mapper function that has the same name as
the helper column you want to manage.}

\item{default}{The default for the argument that was specified in \code{var_arg}.}

\item{affix}{Boolean (length 1). If \code{data} doesn't include the helper column
already, should \code{var_arg} be added to \code{data}, bearing its proper name?
Default is \code{TRUE}.}
}
\value{
The input data frame,  \code{data}, possibly modified (see \code{affix}
argument).
}
\description{
If your consistency test mapper function supports helper
columns, call \code{manage_helper_col()} internally; once for every such column.
It will check whether a helper column is compatible with its eponymous
argument, i.e., if the argument was not specified by the user but has its
default value.

By default (\code{affix = TRUE}), the function will add the column to the
mapper's input data frame. It returns the input data frame, so reassign its
output to that variable.

All of this only works in mapper functions that were "handwritten" using
\verb{function()}, as opposed to those produced by \code{function_map()}. See
\code{vignette("consistency-tests")}, section \emph{Writing mappers manually}.
}
