% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse-map-total-n.R
\name{reverse_map_total_n}
\alias{reverse_map_total_n}
\title{Reverse the \verb{*_map_total_n()} process}
\usage{
reverse_map_total_n(data)
}
\arguments{
\item{data}{Data frame that inherits the \code{"scr_map_total_n"} class.}
}
\value{
The reconstructed tibble (data frame) which a factory-made
\verb{*_map_total_n()} function took as its \code{data} argument.
}
\description{
\code{reverse_map_total_n()} takes the output of a function created
by \code{function_map_total_n()} and reconstructs the original data frame.

See \code{audit_total_n()}, which takes \code{reverse_map_total_n()} as a basis.
}
\examples{
# Originally reported summary data...
df <- tibble::tribble(
  ~x1,    ~x2,   ~n,
  "3.43", "5.28", 90,
  "2.97", "4.42", 103
)
df

# ...GRIM-tested with dispersed `n` values...
out <- grim_map_total_n(df)
out

# ...and faithfully reconstructed:
reverse_map_total_n(out)
}
