% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset-superset.R
\name{subset-superset}
\alias{subset-superset}
\alias{is_subset_of}
\alias{is_superset_of}
\alias{is_equal_set}
\alias{is_proper_subset_of}
\alias{is_proper_superset_of}
\alias{is_subset_of_vals}
\alias{is_superset_of_vals}
\alias{is_equal_set_vals}
\alias{is_proper_subset_of_vals}
\alias{is_proper_superset_of_vals}
\alias{is_subset_of_vecs}
\alias{is_superset_of_vecs}
\alias{is_equal_set_vecs}
\alias{is_proper_subset_of_vecs}
\alias{is_proper_superset_of_vecs}
\title{Test for subsets, supersets, and equal sets}
\usage{
is_subset_of(x, y)

is_superset_of(x, y)

is_equal_set(x, y)

is_proper_subset_of(x, y)

is_proper_superset_of(x, y)

is_subset_of_vals(x, ...)

is_superset_of_vals(x, ...)

is_equal_set_vals(x, ...)

is_proper_subset_of_vals(x, ...)

is_proper_superset_of_vals(x, ...)

is_subset_of_vecs(x, ...)

is_superset_of_vecs(x, ...)

is_equal_set_vecs(x, ...)

is_proper_subset_of_vecs(x, ...)

is_proper_superset_of_vecs(x, ...)
}
\arguments{
\item{x}{A vector.}

\item{y}{A vector. Only in the basic functions, not those with \verb{*_vals()} or
\verb{*_vecs()}.}

\item{...}{In the \verb{*_vals()} functions, any number of values \code{x} might
contain; in the \verb{*_vecs()} functions, any number of vectors the elements of
which \code{x} might contain.}
}
\value{
A single logical value. \code{TRUE} if the respective test was passed,
\code{FALSE} otherwise.
}
\description{
Predicate functions that take a vector and test whether it has
some particular relation to another vector. That second vector is entered
in either of three ways --

\strong{Enter it directly (basic functions):}

\code{is_subset_of()} tests if a vector is a subset of another vector; i.e., if
all its elements are contained in the second one. \code{is_superset_of()} does
the reverse: It tests if the first vector contains all elements of the
second one. \code{is_equal_set()} tests if both vectors have exactly the same
values.

\strong{Enter its values:}

\code{is_subset_of_vals()}, \code{is_superset_of_vals()}, and \code{is_equal_set_vals()}
are variants that each take a single vector plus any number of other
arguments. These are treated like elements of the second vector in the
basic functions above.

\strong{Enter multiple vectors that jointly contain its values:}

Finally, \code{is_subset_of_vecs()}, \code{is_superset_of_vecs()}, and
\code{is_equal_set_vecs()} take one vector plus any number of other vectors and
treat their elements (!) like elements of a second vector in the basic
functions above.

Each \verb{is_subset*()} function has an \verb{is_proper_subset*()} variant. These
variants also test whether the sets are unequal, so that \code{x} is a subset of
\code{y} but \code{y} is not a subset of \code{x}. The same applies to \verb{is_superset*()}
functions and their \verb{is_proper_superset*()} variants.
}
\details{
The \verb{*_vals()} variants are meant for flexible, interactive
subset/superset testing. That is, in order to test whether certain values
collectively fulfill the role of the second vector, you can just add them
to the function call.

The \verb{*_vecs()} variants likewise offer flexibility, but also bridge the gap
between vectors and values contained in them.

All functions simply check if values are present, regardless of how often a
value occurs. In other words, they look for types but don't count tokens.
}
\examples{
# Define example vectors:
ab <- c("a", "b")
abc <- c("a", "b", "c")
abcde <- c("a", "b", "c", "d", "e")

# `is_subset_of()` tests if a vector is
# completely covered by another one:
abc \%>\% is_subset_of(ab)
abc \%>\% is_subset_of(abc)
abc \%>\% is_subset_of(abcde)

# To the contrary, `is_superset_of()` tests if the
# first vector completely covers the second one:
abc \%>\% is_superset_of(ab)
abc \%>\% is_superset_of(abc)
abc \%>\% is_superset_of(abcde)

# `is_equal_set()` tests both of the above --
# i.e., if both vectors have exactly the
# same values:
abc \%>\% is_equal_set(ab)
abc \%>\% is_equal_set(abc)
abc \%>\% is_equal_set(abcde)

# Each of the three functions has a `*_vals()` variant
# that doesn't take a second vector like the first
# one, but any number of other arguments. These are
# jointly treated like the elements of the second
# vector in the basic functions:
abc \%>\% is_subset_of_vals("a", "b")
abc \%>\% is_subset_of_vals("a", "b", "c")
abc \%>\% is_subset_of_vals("a", "b", "c", "d", "e")

# (... and likewise for supersets and equal sets.)
}
