% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_rename.R
\name{hier_rename}
\alias{hier_rename}
\title{Rename nodes in an existing hierarchy}
\usage{
hier_rename(tree, nodes)
}
\arguments{
\item{tree}{a (nested) hierarchy created using \code{\link[=hier_create]{hier_create()}}
or modified using \code{\link[=hier_add]{hier_add()}}, \code{\link[=hier_delete]{hier_delete()}} or \code{\link[=hier_rename]{hier_rename()}}.}

\item{nodes}{(character) new names of nodes/levels that should be changed as
a named vector: names refer to old, existing names, the values to the
new labels}
}
\description{
This function allows to rename one or more node(s) (levels)
in an existing nested hierarchy.
}
\examples{
h <- hier_create(root = "Total",  nodes = LETTERS[1:3])
h <- hier_add(h, root = "A", nodes = c("a1", "a5"))
hier_display(h)

h <- hier_rename(h, nodes = c("a1" = "x1", "A" = "X"))
hier_display(h)
}
