% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modRisk.R
\docType{methods}
\name{modRisk}
\alias{modRisk}
\alias{modRisk,data.frame-method}
\alias{modRisk,matrix-method}
\alias{modRisk,sdcMicroObj-method}
\alias{modRisk-methods}
\title{Global risk using log-linear models.}
\usage{
modRisk(obj, method = "default", weights, formulaM, bound = Inf, ...)
}
\arguments{
\item{obj}{An \code{\link{sdcMicroObj-class}}-object or a numeric matrix
or data.frame containing all variables required in the specified model.}

\item{method}{chose method for model-based risk-estimation. Currently, the
following methods can be selected:
\itemize{
\item "default": the standard log-linear model.
\item "CE": the Clogg Eliason method, additionally,  considers survey weights by using an offset term.
\item "PML": the pseudo maximum likelihood method.
\item "weightedLLM": the weighted maximum likelihood method, considers survey weights by including them as one of the predictors.
\item "IPF": iterative proportional fitting as used in deprecated method 'LLmodGlobalRisk'.
}}

\item{weights}{a variable name specifying sampling weights}

\item{formulaM}{A formula specifying the model.}

\item{bound}{a number specifying a threshold for 'risky' observations in the sample.}

\item{...}{additional parameters passed through, currently ignored.}
}
\value{
Two global risk measures and some model output given the specified model. If this method
is applied to an \code{\link{sdcMicroObj-class}}-object, the slot 'risk' in the object ist updated
with the result of the model-based risk-calculation.
}
\description{
The sample frequencies are assumed to be independent and following a Poisson
distribution. The parameters of the corresponding parameters are estimated
by a log-linear model including the main effects and possible interactions.
}
\details{
This measure aims to (1) calculate the number of sample uniques that are
population uniques with a probabilistic Poisson model and (2) to estimate
the expected number of correct matches for sample uniques.

ad 1) this risk measure is defined over all sample uniques as \deqn{ \tau_1
= \sum\limits_{j:f_j=1} P(F_j=1 | f_j=1) \quad , } i.e. the expected number
of sample uniques that are population uniques.

ad 2) this risk measure is defined over all sample uniques as \deqn{ \tau_2
= \sum\limits_{j:f_j=1} P(1 / F_j | f_j=1) \quad . }

Since population frequencies \eqn{F_k} are unknown, they need to be
estimated.

The iterative proportional fitting method is used to fit the parameters of
the Poisson distributed frequency counts related to the model specified to
fit the frequency counts. The obtained parameters are used to estimate a
global risk, defined in Skinner and Holmes (1998).
}
\examples{
## data.frame method
data(testdata2)
form <- ~sex+water+roof
w <- "sampling_weight"
(modRisk(testdata2, method="default", formulaM=form, weights=w))
(modRisk(testdata2, method="CE", formulaM=form, weights=w))
(modRisk(testdata2, method="PML", formulaM=form, weights=w))
(modRisk(testdata2, method="weightedLLM", formulaM=form, weights=w))
(modRisk(testdata2, method="IPF", formulaM=form, weights=w))

## application to a sdcMicroObj
data(testdata2)
sdc <- createSdcObj(testdata2,
 keyVars=c('urbrur','roof','walls','electcon','relat','sex'),
 numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- modRisk(sdc,form=~sex+water+roof)
slot(sdc, "risk")$model
}
\author{
Matthias Templ, Marius Totter, Bernhard Meindl
}
\references{
Skinner, C.J. and Holmes, D.J. (1998) \emph{Estimating the
re-identification risk per record in microdata}. Journal of Official
Statistics, 14:361-372, 1998.

Rinott, Y. and Shlomo, N. (1998). \emph{A Generalized Negative Binomial
Smoothing Model for Sample Disclosure Risk Estimation}. Privacy in
Statistical Databases. Lecture Notes in Computer Science.  Springer-Verlag,
82--93.

Clogg, C.C. and Eliasson, S.R. (1987). \emph{Some Common Problems in Log-Linear Analysis}. Sociological Methods and Research, 8-44.
}
\seealso{
\code{\link{loglm}}, \code{\link{measure_risk}}
}
\keyword{manip}

