% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generics_sdcProblem.r, R/methods_class_sdcProblem.r
\docType{methods}
\name{get.sdcProblem}
\alias{get.sdcProblem}
\alias{get.sdcProblem,sdcProblem,character-method}
\title{query \code{sdcProblem}-objects depending on argument \code{type}}
\usage{
get.sdcProblem(object, type)

\S4method{get.sdcProblem}{sdcProblem,character}(object, type)
}
\arguments{
\item{object}{an object of class \code{sdcProblem}}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item dataObj: a list containing the (raw) input data
\item problemInstance: return the current problem instance
\item partition: a list containing information on the subtables that are required to be protected as well as information on the processing order of the subtables
\item elapsedTime: the elapsed time of the protection algorithm so far
\item dimInfo: information on the variables defining the hierarchical table
\item indicesDealtWith: a set of indices that have already been dealt with during the protection algorithmus
\item startI: current level at which subtables need to be protected (useful when restarting HITAS|HYPERCUBE)
\item startJ: current number of the subtable within a given level that needs to be protected (useful when restarting HITAS|HYPERCUBE)
\item innerAndMarginalCellInfo: for a given problem, get indices of inner- and marginal table cells}
}
\value{
information from objects of class \code{sdcProblem} depending on argument \code{type}
\itemize{
\item an object of class \code{dataObj} (or NULL) if \code{type} matches 'dataObj'
\item an object of class \code{problemInstance} (or NULL) if \code{type} matches 'problemInstance'
\item a list (or NULL) if argument \code{type} matches 'partition' containing the following elements:
\itemize{
\item element 'groups': list with each list-element being a character vector specifying a specific level-group
\item element 'indices': list with each list-element being a numeric vector defining indices of a subtable
\item element 'strIDs': list with each list-element being a character vector defining IDs of a subtable
\item element 'nrGroups': numeric vector of length 1 defining the total number of groups that have to be considered
\item element 'nrTables': numeric vector of length 1 defining the total number of subtables that have to be considered}
\item a list (or NULL) if argument \code{type} matches 'innerAndMarginalCellInfo' containing the following elements:
\itemize{
\item element 'innerCells': character vector specifying ID's of inner cells
\item element 'totCells': character vector specifying ID's of marginal cells
\item element 'indexInnerCells': numeric vector specifying indices of inner cells
\item element 'indexTotCells': numeric vector specifying indices of marginal cells}
\item an object of class \code{dimInfo} (or NULL) if \code{type} matches 'dimInfo'
\item numeric vector if argument \code{type} matches 'elapsedTime'
\item numeric vector of length 1 if argument \code{type} matches 'startI' or 'startJ'
}
}
\description{
query \code{sdcProblem}-objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

