% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{sdcSubstitutionMatrixClass-class}
\alias{initialize,sdcSubstitutionMatrixClass-method}
\alias{sdcSubstitutionMatrixClass-class}
\title{S4 Substitution Matrix}
\usage{
\S4method{initialize}{sdcSubstitutionMatrixClass}(.Object, ...)
}
\arguments{
\item{.Object}{An \code{\linkS4class{sdcSubstitutionMatrixClass}} object.}

\item{...}{The optional parameters specifying the basis of the
substitution matrix. These include an indicator of
forwards or backwards matrix calculation
(\code{forwards}),
a cutoff value relative to entries in the target matrix
(\code{cutoff}), and the target matrix basis for the
calculation (\code{T}).}
}
\description{
The substitution matrix is a matrix with the same dimensions as the
  data from which it is derived, that indicates which elements are to
  be subjected to a statistical disclosure control process.
}
\details{
The substitution matrix is calculated from a target matrix.
  Specification of forwards direction with a \code{cutoff} of 0
  results in a complete data synthesis substitution matrix.
  Specification of forwards direction with a \code{cutoff} of 1,
  or backwards direction with a sufficiently large \code{cutoff},
  results in the maximum partial synthesis substitution matrix.
  Specification of backwards direction with a \code{cutoff} of 1
  results in the minimum partial synthesis substitution matrix.
  Maximum partial synthesis is the default.
}
\section{Methods (by generic)}{
\itemize{
\item \code{initialize}: 
}}
\section{Slots}{

\describe{
\item{\code{.Data}}{A matrix.}

\item{\code{forwards}}{Indicates the direction in which to process the target matrix.
Defaults to \code{TRUE}.}

\item{\code{cutoff}}{Cutoff with respect to which an element in the target matrix
should be indicated for substitution. Default value is 1.}

\item{\code{T}}{A target matrix object.}
}}
\examples{
set.seed(256)
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
my.smc <- new("sdcSubstitutionMatrixClass",
              T = new("sdcTargetMatrixClass",
                      Tdef = new("sdcTargetDefinitionClass", X = my.X)))
}
\seealso{
\code{\linkS4class{sdcTargetMatrixClass}},
}

