% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{mcTorusIntegrate}
\alias{mcTorusIntegrate}
\title{Monte Carlo integration on the torus}
\usage{
mcTorusIntegrate(f, p, M = 1e+05, fVect = TRUE, ...)
}
\arguments{
\item{f}{function to be integrated.}

\item{p}{dimension of the torus.}

\item{M}{number of Monte Carlo replicates.}

\item{fVect}{is \code{f} vectorized?}

\item{...}{further parameters passed to \code{f}.}
}
\value{
A scalar with the approximated integral.
}
\description{
Convenience function for Monte Carlo integration on \eqn{[-\pi, \pi)^p}.
}
\examples{
# Integral of sin(x1) * cos(x2), must be close to 0
mcTorusIntegrate(f = function(x) sin(x[, 1]) * cos(x[, 2]), p = 2)
}
\keyword{internal}
