% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdmApp_TimesRasters.R
\name{sdmApp_TimesRasters}
\alias{sdmApp_TimesRasters}
\title{Multiply the probability of occurrence map with the presence/absence map to get a presence map only.}
\usage{
sdmApp_TimesRasters(x, y)
}
\arguments{
\item{x}{Probability of occurrence map, a \code{Raster object}}

\item{y}{Presence/Absence map, a \code{Raster object}}
}
\value{
Probability of occurrence map with only presence
}
\description{
Multiply the probability of occurrence map with the presence/absence map to get a presence map only.
}
\examples{
r <- raster::raster(system.file("extdata","AETI.tif",package = "sdmApp"))
r2 <- r > raster::cellStats(r, stat='mean', na.rm=TRUE)
r <- r/raster::maxValue(r)
names(r) <- "propability of occurence"
z<-sdmApp_TimesRasters(r,r2)
sdmApp_RasterPlot(z)
}
