% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans.R
\name{emmeans.sdmTMB}
\alias{emmeans.sdmTMB}
\title{Estimated marginal means with the \pkg{emmeans} package with \pkg{sdmTMB}}
\description{
Methods for using the \pkg{emmeans} package with \pkg{sdmTMB}. The
\pkg{emmeans} package computes estimated marginal means for the fixed
effects.
}
\examples{
\dontshow{if (require("emmeans", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mesh <- make_mesh(pcod_2011, c("X", "Y"), cutoff = 20)
fit <- sdmTMB(
  present ~ as.factor(year),
  data = pcod_2011, mesh = mesh,
  family = binomial()
)
fit
emmeans::emmeans(fit, ~ year)
emmeans::emmeans(fit, pairwise ~ year)
emmeans::emmeans(fit, pairwise ~ year, type = "response")
emmeans::emmeans(fit, pairwise ~ year, adjust = "none")

e <- emmeans::emmeans(fit, ~ year)
plot(e)

e <- emmeans::emmeans(fit, pairwise ~ year)
confint(e)
summary(e, infer = TRUE)
as.data.frame(e)

# interaction of factor with continuous predictor:
fit2 <- sdmTMB(
  present ~ depth_scaled * as.factor(year),
  data = pcod_2011, mesh = mesh,
  family = binomial()
)
fit2
# slopes for each level:
emmeans::emtrends(fit2, ~ year, var = "depth_scaled")
# test difference in slopes:
emmeans::emtrends(fit2, pairwise ~ year, var = "depth_scaled")
emmeans::emmip(fit2, year ~ depth_scaled,
  at = list(depth_scaled = seq(-2.5, 2.5, length.out = 50)), CIs = TRUE)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://aosmith.rbind.io/2019/03/25/getting-started-with-emmeans/}
}
