\name{artificialBellResponse}

\alias{artificialBellResponse}

\title{
artificial bell-shaped response method
}

\description{ 
use artificial bell-shaped response method to create virtual species.
}

\usage{
artificialBellResponse(env.stack, config, stack=FALSE, compose="product")
}

\arguments{
  \item{env.stack}{A RasterStack object}
  \item{config}{list. Contain the configure information for this method)}
  \item{stack}{logical, New in version 0.2. if you want return a RasterStack object rather than combine them together?}
  \item{compose}{string, New in version 0.2. using what method to compose the finally suitability? current you can choose "product" and "sum"}
}

\value{
A RasterLayer or RasterStack object that is the virtual species distribution map
}

\author{
Howl Anderson
}

\examples{
# load the sdmvspecies library
library("sdmvspecies")
# find package's location
package.dir <- system.file(package="sdmvspecies")
# let see where is our sdmvspecies is installed in
package.dir
# find env dir under the package's location
env.dir <- paste(package.dir, "/external/env/", sep="")
# let see env dir
env.dir
# get the environment raster file
file.name <- files <- c("bio1.bil", "bio12.bil", "bio7.bil", "bio5.bil")
files <- paste(env.dir, file.name, sep="")
# make raster stack
env.stack <- stack(files)
# config
config <- list(c("bio1",150, 50), c("bio12", 2000, 500), c("bio7", 400, 100), c("bio5", 300, 100))
# run pick mean
species.raster <- artificialBellResponse(env.stack, config)
# plot map
plot(species.raster)
# species distribution map
species.distribution.raster <- species.raster > 0.2
# plot map
plot(species.distribution.raster)
}

\keyword{artificial bell-shaped response method}
