% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spdep_helpers.R
\name{spdep_skater}
\alias{spdep_skater}
\title{spatial c(k)luster analysis by tree edge removal}
\usage{
spdep_skater(sfj, k = 6, nb = NULL, ini = 5, ...)
}
\arguments{
\item{sfj}{An \code{sf} object of observation data. Please ensure that the attribute columns are included
in the SKATER analysis.}

\item{k}{(optional) The number of clusters. Default is \code{6}.}

\item{nb}{(optional) A neighbours list with class nb. If the input \code{nb} is NULL, it will be constructed
automatically using \code{spdep_nb()}.}

\item{ini}{(optional) The initial node in the minimal spanning tree. Defaul is \code{5}.}

\item{...}{(optional) Other parameters passed to spdep::skater().}
}
\value{
A numeric vector of clusters.
}
\description{
SKATER forms clusters by spatially partitioning data that has similar values for features of interest.
}
\examples{
gzma = sf::read_sf(system.file('extdata/gzma.gpkg',package = 'sdsfun'))
gzma_c = spdep_skater(gzma,8)
gzma$group = gzma_c
plot(gzma["group"])

}
